@if ($errors->any())

    <div class="relative p-3 pr-12 text-sm text-red-500 border border-transparent rounded-md bg-red-50 dark:bg-red-400/20">
        <button onclick="this.closest('div').remove()" class="absolute top-0 bottom-0 right-0 p-3 text-red-200 transition hover:text-red-500 dark:text-red-400/50 dark:hover:text-red-500"><i data-lucide="x" class="h-5"></i></button>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

@if(\Session::has('success'))
    <div class="relative p-3 pr-12 text-sm text-green-500 border border-transparent rounded-md bg-green-50 dark:bg-green-400/20">
        <button onclick="this.closest('div').remove()" class="absolute top-0 bottom-0 right-0 p-3 transition text-custom-200 hover:text-custom-500 dark:text-custom-400/50 dark:hover:text-custom-500"><i data-lucide="x" class="h-5"></i></button>
        {{\Illuminate\Support\Facades\Session::get('success') }}
    </div>
@endif

@if(\Session::has('error'))
    <div class="relative p-3 pr-12 text-sm text-red-500 border border-transparent rounded-md bg-red-50 dark:bg-red-400/20">
        <button onclick="this.closest('div').remove()" class="absolute top-0 bottom-0 right-0 p-3 text-red-200 transition hover:text-red-500 dark:text-red-400/50 dark:hover:text-red-500"><i data-lucide="x" class="h-5"></i></button>
        {{\Illuminate\Support\Facades\Session::get('error') }}
    </div>
@endif
