@props(['column' => 3, 'categoryPath' => []])

<div class="grid grid-cols-1 xl:grid-cols-12 gap-x-5">
    {{-- Static root category --}}
    <div class="lg:col-span-2 xl:col-span-{{$column}}">
        <label for="tax" class="inline-block mb-2 text-base font-medium">Category</label>
        <div id="category-selectors">
            <select class="form-control" onchange="loadChildren(this.value, 1)">
                <option value="">Select Root Category</option>
                @foreach ($categories as $category)
                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                @endforeach
            </select>
            @error('final_category_id')
            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
            @enderror
        </div>
        <input type="hidden" name="final_category_id" id="final_category_id">
    </div>

    {{-- Dynamic select options go here --}}
    <div id="dynamic-category-selects" class="contents"></div>
</div>

    @push('scripts')
        <script>
            function loadChildren(parentId, level) {
                fetch(`/admin/inventory/getCategories/${parentId}`)
                    .then(res => res.json())
                    .then(data => {
                        const container = document.getElementById("dynamic-category-selects");

                        // Remove previous levels
                        const children = container.querySelectorAll(`.category-level`);
                        children.forEach((el, index) => {
                            if (index >= level - 1) el.remove();
                        });

                        if (data.length > 0) {
                            // Create wrapper div
                            const wrapper = document.createElement("div");
                            wrapper.className = "category-level lg:col-span-2 xl:col-span-3";

                            // Create label
                            const label = document.createElement("label");
                            label.className = "inline-block mb-6 text-base font-medium";
                            label.textContent = ""; // empty to match layout spacing

                            // Create select
                            const select = document.createElement("select");
                            select.className = "form-control";
                            select.innerHTML = '<option value="">Select Subcategory</option>' +
                                data.map(c => `<option value="${c.id}">${c.name}</option>`).join("");
                            select.onchange = () => loadChildren(select.value, level + 1);

                            // Assemble block
                            wrapper.appendChild(label);
                            wrapper.appendChild(select);
                            container.appendChild(wrapper);
                        }

                        // Always update final category ID
                        document.getElementById('final_category_id').value = parentId;
                    });
            }
        </script>
    @endpush

