@props(['options' => [], 'name', 'value', 'label', 'mandatory' => false, 'disabled' => false])

<label for="{{$name}}" class="inline-block mb-2 text-base font-medium"> {{ $label ?? $slot }}</label>
<span class="text-red-500">{{$mandatory ? '*':''}}</span>

<select
    {{ $disabled ? 'disabled' : '' }}
    id="{{$name}}"
    name="{{$name}}"
    class="form-control form-input w-full @error($name) border-red-500 @enderror"
    data-choices="">
    <option value="">{{__('--Please Select--')}}</option>
    @foreach($options as $item)
        <option value="{{$item->id}}" {{$item->id == $value ? 'selected':'' }}>{{$item->name}}</option>
    @endforeach
</select>
<p id="{{$name}}Error" class="mt-1 text-sm text-red-500"></p>
@error($name)
<p class="text-sm text-red-600 mt-1">{{ $message }}</p>
@enderror

