@props(['name', 'label', 'mandatory' => false, 'disabled' => false])

<label for="{{$name}}" class="inline-block mb-2 text-base font-medium"> {{ $label ?? $slot }}</label>
<span class="text-red-500">{{$mandatory ? '*':''}}</span>

<input type="password" name="{{$name}}" id="{{$name}}" wire:model.lazy="{{$name}}" placeholder="{{$label}}" {{ $disabled ? 'disabled' : '' }} {!! $attributes->merge(['class' => 'form-control']) !!}>
<p id="{{$name}}Error" class="mt-1 text-sm text-red-500 error"></p>

