@props(['column' => 3, 'categoryPath' => []])

<div class="grid grid-cols-1 xl:grid-cols-12 gap-x-5">
    {{-- Static root category --}}
    <div class="lg:col-span-2 xl:col-span-{{$column}}">
        <label for="tax" class="inline-block mb-2 text-base font-medium">Category</label>
        <div id="category-selectors">
            <select class="form-control" onchange="loadChildren(this.value, 1)">
                <option value="">Select Root Category</option>
                @foreach ($categories as $category)
                    <option value="{{ $category->id }}"
                            @if(isset($categoryPath[0]) && $categoryPath[0]->id === $category->id) selected @endif>
                        {{ $category->name }}
                    </option>
                @endforeach
            </select>
            @error('final_category_id')
            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
            @enderror
        </div>
        <input type="hidden" name="final_category_id" id="final_category_id" value="{{ end($categoryPath)->id ?? '' }}">
    </div>

    {{-- Preload subcategories based on the path --}}
    @if (!empty($categoryPath))
    <div id="dynamic-category-selects" class="contents">
        @foreach($categoryPath as $index => $selected)
            @if($index === 0) @continue @endif
            @php
                $children = $selected->parent
                            ? $selected->parent->children
                            : collect();
            @endphp
            <div class="category-level lg:col-span-2 xl:col-span-3">
                <label class="inline-block mb-6 text-base font-medium"></label>
                <select class="form-control" onchange="loadChildren(this.value, {{ $index + 1 }})">
                    <option value="">Select Subcategory</option>
                    @foreach($children as $child)
                        <option value="{{ $child->id }}"
                                @if($child->id === $categoryPath[$index]->id) selected @endif>
                            {{ $child->name }}
                        </option>
                    @endforeach
                </select>
            </div>
        @endforeach
    </div>
    @endif

    {{-- Dynamic select options go here --}}
    <div id="dynamic-category-selects" class="contents"></div>
</div>

    @push('scripts')
        <script>
            function loadChildren(parentId, level) {
                fetch(`/admin/inventory/getCategories/${parentId}`)
                    .then(res => res.json())
                    .then(data => {
                        const container = document.getElementById("dynamic-category-selects");

                        // Remove selects at the current level or deeper
                        const children = container.querySelectorAll(`.category-level`);
                        children.forEach((el, index) => {
                            if (index >= level - 1) el.remove();
                        });

                        if (data.length > 0) {
                            const wrapper = document.createElement("div");
                            wrapper.className = "category-level lg:col-span-2 xl:col-span-3";

                            const label = document.createElement("label");
                            label.className = "inline-block mb-6 text-base font-medium";
                            label.textContent = "";

                            const select = document.createElement("select");
                            select.className = "form-control";
                            select.innerHTML = '<option value="">Select Subcategory</option>' +
                                data.map(c => `<option value="${c.id}">${c.name}</option>`).join("");
                            select.onchange = () => loadChildren(select.value, level + 1);

                            wrapper.appendChild(label);
                            wrapper.appendChild(select);
                            container.appendChild(wrapper);
                        }

                        document.getElementById('final_category_id').value = parentId;
                    });
            }

        </script>
    @endpush

