@props(['name', 'label', 'rows', 'mandatory' => false, 'disabled' => false])

<label for="{{$name}}" class="inline-block mb-2 text-base font-medium"> {{ $label ?? $slot }}</label>
<span class="text-red-500">{{$mandatory ? '*':''}}</span>

{{--<input type="text" name="{{$name}}" id="{{$name}}"  placeholder="{{$label}}" {{ $disabled ? 'disabled' : '' }} {!! $attributes->merge(['class' => 'form-control']) !!}>--}}

<textarea
    class="form-control form-input w-full @error($name) border-red-500 @enderror"
    id="{{$name}}"
    name="{{$name}}"
    rows="{{$rows}}">{{ $attributes['value'] ?? '' }}</textarea>

<p id="{{$name}}Error" class="mt-1 text-sm text-red-500 error"></p>
@error($name)
<p class="text-sm text-red-600 mt-1">{{ $message }}</p>
@enderror

