<?php

use App\Http\Controllers\Admin\AdminsController;
use App\Http\Controllers\Admin\Hrm\EmployeeController;
use App\Http\Controllers\Admin\Inventory\Setup\GroupController;
use App\Http\Controllers\RolesController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Auth\LoginController;

Route::middleware('admin.guest')->group(function () {

    Route::get('/', [LoginController::class, 'create'])
        ->name('/');

    Route::get('login', [LoginController::class, 'create'])
        ->name('login');

    Route::post('login', [LoginController::class, 'store']);

});


Route::middleware('admin.auth')->group(function () {

    Route::group(['prefix'=>'admin','as'=>'admin.'], function() {

        Route::get('/dashboard', function () {
            return view('admin.dashboard');
        })->name('dashboard');

        Route::resource('roles', RolesController::class)->names([
            'index'   => 'roles.index',
            'create'  => 'roles.create',
            'store'   => 'roles.store',
            'show'    => 'roles.show',
            'edit'    => 'roles.edit',
            'update'  => 'roles.update',
            'destroy' => 'roles.destroy',
        ]);

        Route::resource('admins', AdminsController::class)->names([
            'index'   => 'admins.index',
            'create'  => 'admins.create',
            'store'   => 'admins.store',
            'show'    => 'admins.show',
            'edit'    => 'admins.edit',
            'update'  => 'admins.update',
            'destroy' => 'admins.destroy',
        ]);
        //Route::resource('admins',AdminsController::class,['names'  => 'admin.admins']);

        ##===> HRM
        Route::group(['prefix'=>'hrm','as'=>'hrm.'], function(){
            Route::group(['prefix'=>'employee','as'=>'employee.'], function(){
                Route::get('list', [EmployeeController::class, 'index'])->name('list');
                Route::post('store', [EmployeeController::class, 'store'])->name('saveEmployee');
                Route::get('view/{code}', [EmployeeController::class, 'view'])->name('view');
                Route::get('store/{code}', [EmployeeController::class, 'empInventory'])->name('store');
                Route::get('login/{code}', [EmployeeController::class, 'login'])->name('login');
                Route::post('storeEmployeeLogin/{id?}', [EmployeeController::class, 'storeEmployeeLogin'])->name('storeEmployeeLogin');
                Route::post('updateEmployeeInfo/{id}', [EmployeeController::class, 'updateEmployeeInfo'])->name('updateEmployeeInfo');
                Route::post('storeEmployeeContact/{id?}', [EmployeeController::class, 'storeEmployeeContact'])->name('storeEmployeeContact');
                Route::post('findStoreByBUnit/{id?}', [EmployeeController::class, 'findStoreByBUnit'])->name('findStoreByBUnit');
                Route::post('storeEmployeeBusinessUnitStore/{id?}', [EmployeeController::class, 'storeEmployeeBusinessUnitStore'])->name('storeEmployeeBusinessUnitStore');
            });

            Route::group(['prefix'=>'setup','as'=>'setup.'], function(){
                //Route::resource('unit', BusinessUnitController::class);
            });

        });

        Route::post('logout', [LoginController::class, 'destroy'])
            ->name('logout');
    });
});
