<?php

use App\Http\Controllers\Admin\Inventory\Setup\ChartInventoryController;
use App\Http\Controllers\Admin\Inventory\Setup\HeadController;
use App\Http\Controllers\Admin\Inventory\Setup\GroupController;
use App\Http\Controllers\Admin\Inventory\Setup\CategoryController;
use App\Http\Controllers\Admin\Inventory\Setup\SubCategoryController;
use App\Http\Controllers\Admin\Inventory\Setup\UnitController;
use App\Http\Controllers\Admin\Inventory\Setup\TaxController;
use App\Http\Controllers\Admin\Inventory\Setup\BrandController;
use App\Http\Controllers\Admin\Inventory\Setup\AttributeController;
use App\Http\Controllers\Admin\Inventory\Setup\AttributeValueController;
use App\Http\Controllers\Admin\Inventory\InventoryController;
use Illuminate\Support\Facades\Route;


Route::middleware('admin.auth')->group(function () {
    Route::group(['prefix'=>'admin','as'=>'admin.'], function() {

        ##===> Inventory
        Route::group(['prefix'=>'inventory','as'=>'inventory.'], function(){
            Route::group(['prefix'=>'setup','as'=>'setup.'], function(){
                #HEAD
                Route::get('headList', [HeadController::class, 'index'])->name('headList');
                Route::post('headStoreOrUpdate', [HeadController::class, 'storeOrUpdate'])->name('headStoreOrUpdate');
                Route::get('editHead/{id?}', [HeadController::class, 'edit'])->name('editHead');
                Route::post('deleteHead', [HeadController::class, 'delete'])->name('deleteHead');
                #CHART OF INVENTORY
                Route::get('chart-of-inventory', [ChartInventoryController::class, 'index'])->name('chart-of-inventory');
                Route::post('inventoryStoreOrUpdate', [ChartInventoryController::class, 'inventoryStoreOrUpdate'])->name('inventoryStoreOrUpdate');
                Route::post('inventoryDelete', [ChartInventoryController::class, 'inventoryDelete'])->name('inventoryDelete');
                #GROUP
                Route::get('groupList', [GroupController::class, 'index'])->name('groupList');
                Route::post('storeOrUpdate', [GroupController::class, 'storeOrUpdate'])->name('storeOrUpdate');
                Route::get('editGroup/{id?}', [GroupController::class, 'editGroup'])->name('editGroup');
                #Category
                Route::get('categoryList', [CategoryController::class, 'index'])->name('categoryList');
                Route::post('categoryStoreOrUpdate', [CategoryController::class, 'storeOrUpdate'])->name('categoryStoreOrUpdate');
                Route::get('editCategory/{id?}', [CategoryController::class, 'edit'])->name('editCategory');
                #Category
                Route::get('subCategoryList', [SubCategoryController::class, 'index'])->name('subCategoryList');
                Route::post('subCategoryStoreOrUpdate', [SubCategoryController::class, 'storeOrUpdate'])->name('subCategoryStoreOrUpdate');
                Route::get('editSubCategory/{id?}', [SubCategoryController::class, 'edit'])->name('editSubCategory');
                Route::get('getCategories/{groupId?}', [SubCategoryController::class, 'getCategories'])->name('getCategories');
                #Unit
                Route::get('unitList', [UnitController::class, 'index'])->name('unitList');
                Route::post('unitStoreOrUpdate', [UnitController::class, 'storeOrUpdate'])->name('unitStoreOrUpdate');
                Route::get('editUnit/{id?}', [UnitController::class, 'editGroup'])->name('editUnit');
                #Tax
                Route::get('taxList', [TaxController::class, 'index'])->name('taxList');
                Route::post('taxStoreOrUpdate', [TaxController::class, 'storeOrUpdate'])->name('taxStoreOrUpdate');
                Route::get('editTax/{id?}', [TaxController::class, 'edit'])->name('editTax');
                #Brand
                Route::get('brandList', [BrandController::class, 'index'])->name('brandList');
                Route::post('brandStoreOrUpdate', [BrandController::class, 'storeOrUpdate'])->name('brandStoreOrUpdate');
                Route::get('editBrand/{id?}', [BrandController::class, 'edit'])->name('editBrand');
                #ATTRIBUTE
                Route::get('attributeList', [AttributeController::class, 'index'])->name('attributeList');
                Route::post('attributeStoreOrUpdate', [AttributeController::class, 'storeOrUpdate'])->name('attributeStoreOrUpdate');
                Route::get('editAttribute/{id?}', [AttributeController::class, 'edit'])->name('editAttribute');
                Route::post('deleteAttribute', [AttributeController::class, 'delete'])->name('deleteAttribute');
                #ATTRIBUTE VALUE
                Route::get('attributeValueList', [AttributeValueController::class, 'index'])->name('attributeValueList');
                Route::post('attributeValueStoreOrUpdate', [AttributeValueController::class, 'storeOrUpdate'])->name('attributeValueStoreOrUpdate');
                Route::get('editAttributeValue/{id?}', [AttributeValueController::class, 'edit'])->name('editAttributeValue');
                Route::post('deleteAttributeValue', [AttributeValueController::class, 'delete'])->name('deleteAttributeValue');
            });

            #INVENTORY ITEM
            Route::get('saleableItem', [InventoryController::class, 'addNewSaleableItem'])->name('saleableItem');
            Route::post('findAttributeValueByAttribute', [InventoryController::class, 'findAttributeValueByAttribute'])->name('findAttributeValueByAttribute');
            Route::post('generateCombinations', [InventoryController::class, 'generateCombinations'])->name('generateCombinations');
            Route::get('getCategories/{id?}', [InventoryController::class, 'getCategories'])->name('getCategories');
            Route::post('storeSaleableItem', [InventoryController::class, 'storeSaleableItem'])->name('storeSaleableItem');
            Route::get('editItem/{code?}', [InventoryController::class, 'editItem'])->name('editItem');
        });

    });
});
