<!DOCTYPE html>
<html lang="en" class="light scroll-smooth group" data-layout="vertical" data-sidebar="light" data-sidebar-size="lg" data-mode="light" data-topbar="light" data-skin="default" data-navbar="sticky" data-content="fluid" dir="ltr">

<head>

    <meta charset="utf-8">
    <title>Amanat Shah Group | Task Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta content="Minimal Admin & Dashboard Template" name="description">
    <meta content="StarCode Kh" name="author">
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon/apple-touch-icon.png')); ?>">
    <!-- Layout config Js -->
    <script src="<?php echo e(asset('assets/js/layout.js')); ?>"></script>
    <!-- Icons CSS -->

    <!-- StarCode CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/starcode2.css')); ?>">
</head>

<body class="flex items-center justify-center min-h-screen px-4 py-16 bg-cover bg-auth-pattern dark:bg-auth-pattern-dark dark:text-zink-100 font-public">

<div class="mb-0 border-none shadow-none xl:w-2/3 card bg-white/70 dark:bg-zink-500/70">
    <div class="grid grid-cols-1 gap-0 lg:grid-cols-12">
        <div class="lg:col-span-5">
            <div class="!px-12 !py-12 card-body">

                <div class="text-center">
                    <h4 class="mb-2 text-purple-500 dark:text-purple-500">Amanat Shah Group</h4>
                    <p class="text-slate-500 dark:text-zink-200">Employee Task Management</p>
                </div>

                <br/>
                <br/>
                <?php if (isset($component)) { $__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.auth-session-status','data' => ['class' => 'mb-4','status' => session('status')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('auth-session-status'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mb-4','status' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('status'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5)): ?>
<?php $attributes = $__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5; ?>
<?php unset($__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5)): ?>
<?php $component = $__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5; ?>
<?php unset($__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5); ?>
<?php endif; ?>
                <form method="POST" action="<?php echo e(route('login')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="username" class="inline-block mb-2 text-base font-medium">UserName/ Email ID</label>
                        <input type="text" id="username"
                               class="form-input dark:bg-zink-600/50 border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600
                               disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:focus:border-custom-800
                               placeholder:text-slate-400 dark:placeholder:text-zink-200" name="email" required autofocus autocomplete="username">
                    </div>
                    <div class="mb-3">
                        <label for="password" class="inline-block mb-2 text-base font-medium">Password</label>
                        <input type="password" id="password" class="form-input dark:bg-zink-600/50 border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500
                        disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200
                        disabled:text-slate-500 dark:text-zink-100 dark:focus:border-custom-800
                        placeholder:text-slate-400 dark:placeholder:text-zink-200"  name="password" required autocomplete="current-password">

                    </div>
                    <div>
                        <div class="flex items-center gap-2">
                            <input id="remember_me" type="checkbox" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" name="remember">
                            <span class="ms-2 text-sm text-gray-600"><?php echo e(__('Remember me')); ?></span>
                        </div>
                        <div id="remember-error" class="hidden mt-1 text-sm text-red-500">Please check the "Remember me" before submitting the form.</div>
                    </div>

                    <div class="mt-10">
                        <button type="submit" class="w-full text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">Sign In</button>
                    </div>



                </form>
            </div>
        </div>
        <div class="mx-2 mt-2 mb-2 border-none shadow-none lg:col-span-7 card bg-white/60 dark:bg-zink-500/60">
            <div class="!px-10 !pt-10 h-full !pb-0 card-body flex flex-col">
                <div class="flex items-center justify-between gap-3">
                    <div class="grow">
                        <a href="#">
                            <img src="<?php echo e(asset('assets/images/asg-logo.png')); ?>" alt="" class="hidden h-15 dark:block">
                            <img src="<?php echo e(asset('assets/images/asg-logo.png')); ?>" alt="" class="block h-15 dark:hidden">
                        </a>
                    </div>

                </div>

            </div>
        </div>
    </div>
</div>

<script src='<?php echo e(asset('assets/libs/choices.js/public/assets/scripts/choices.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/%40popperjs/core/umd/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/tippy.js/tippy-bundle.umd.min.js ')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/simplebar/simplebar.min.js ')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/prismjs/prism.js ')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/lucide/umd/lucide.js ')); ?>"></script>
<script src="<?php echo e(asset('assets/js/starcode.bundle.js ')); ?>"></script>
<script src="<?php echo e(asset('assets/js/pages/auth-login.init.js ')); ?>"></script>

</body>

</html>
<?php /**PATH D:\laragon\www\asg-task\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>